/*
 * Decompiled with CFR 0.152.
 */
package org.agmas.harpymodloader.commands.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.agmas.harpymodloader.modifiers.HMLModifiers;
import org.agmas.harpymodloader.modifiers.Modifier;

public class ModifierArgumentType
implements ArgumentType<Modifier> {
    public static final DynamicCommandExceptionType MODIFIER_EMPTY = new DynamicCommandExceptionType(input -> class_2561.method_43469((String)"argument.harpymodloader.modifier.notfound", (Object[])new Object[]{input}));
    public static final DynamicCommandExceptionType MODIFIER_MULTIPLE = new DynamicCommandExceptionType(input -> class_2561.method_43469((String)"argument.harpymodloader.modifier.found-multiple", (Object[])new Object[]{input}));
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");

    public static ModifierArgumentType create() {
        return new ModifierArgumentType();
    }

    public static Modifier getModifier(CommandContext<class_2168> context, String name) {
        return (Modifier)context.getArgument(name, Modifier.class);
    }

    public Modifier parse(StringReader reader) throws CommandSyntaxException {
        String input = new StringReader(reader).readString();
        class_2960 modifierId = null;
        try {
            modifierId = class_2960.method_12835((StringReader)reader);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (Modifier modifier : HMLModifiers.MODIFIERS) {
            if (!modifier.identifier().equals((Object)modifierId) && !modifier.identifier().method_12832().startsWith(input)) continue;
            result.add(modifier);
        }
        if (result.isEmpty()) {
            throw MODIFIER_EMPTY.create((Object)input);
        }
        if (result.size() > 1) {
            throw MODIFIER_MULTIPLE.create((Object)input);
        }
        return (Modifier)result.getFirst();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9271(HMLModifiers.MODIFIERS.stream(), (SuggestionsBuilder)builder, Modifier::identifier, Modifier::getName);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

